{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 17.11.98 - 16:45:01 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMUtils, MMObj, MMDSPObj, MMAPlay, MMAudio, StdCtrls, MMDIBCv, MMLevel, MMConect,
  MMHook, MMDesign, MMWavOut, MMSlider, ExtCtrls, MMSpectr, MMGauge, MMMPEG;

type
  TForm1 = class(TForm)
    AudioPlayer: TMMAudioPlayer;
    btnPlay: TButton;
    btnStop: TButton;
    btnFile: TButton;
    OpenDialog: TOpenDialog;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnStopFade: TButton;
    SliderPosition: TMMSlider;
    Timer: TTimer;
    Label1: TLabel;
    btnPause: TButton;
    Label2: TLabel;
    Label3: TLabel;
    SliderPitch: TMMSlider;
    Timer1: TTimer;
    StreamGauge: TMMGauge;
    Label4: TLabel;
    Label5: TLabel;
    PlayGauge: TMMGauge;
    procedure btnFileClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopFadeClick(Sender: TObject);
    procedure SliderPositionTrack(Sender: TObject);
    procedure SliderPositionTrackEnd(Sender: TObject);
    procedure AudioPlayerStart(Sender: TObject);
    procedure AudioPlayerStop(Sender: TObject);
    procedure AudioPlayerPause(Sender: TObject);
    procedure AudioPlayerRestart(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SliderPitchChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    Seeking: Boolean;
    FileStream: TFileStream;
    MemStream : TMemoryStream;

    procedure CopyData(nBytes: Longint);
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.CopyData(nBytes: Longint);
begin
   try
      nBytes := Min(nBytes,FileStream.Size-FileStream.Position);
      MemStream.CopyFrom(FileStream,nBytes);
   except
      // no exception please
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   AudioPlayer.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
begin
   if (FileStream = nil) and OpenDialog.Execute then
   begin
      FileStream := TFileStream.Create(OpenDialog.FileName,fmOpenRead);
      //FileStream := TFileStream.Create('C:\MP3Files\NALIN & KANE - BEACHBALL!!S.MP3',fmOpenRead);
      MemStream  := TMemoryStream.Create;

      MemStream.Size := FileStream.Size;
      CopyData(AudioPlayer.NumBuffers*AudioPlayer.BufferSize);

      AudioPlayer.FileName    := 'POINTER://'+IntToHex(Longint(MemStream.Memory),8);

      SliderPosition.MaxValue := AudioPlayer.FileLength;
      SliderPosition.Position := 0;
      btnPlay.Enabled         := True;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if (wosPause in AudioPlayer.State) and (wosPlay in AudioPlayer.State) then
       AudioPlayer.Restart
   else
   begin
      if SliderPosition.Position >= AudioPlayer.FileLength-5000 then
         SliderPosition.Position := 0;

      { set the start position }
      AudioPlayer.Position := SliderPosition.Position;

      Timer1.Enabled := True;

      {set the fade In/Out params }
      //Audioplayer.FadeInDuration := 2500;
      //AudioPlayer.FadeOutDuration := 2500;
      //Audioplayer.FadeOutPosition := AudioPlayer.PlayLength-AudioPlayer.FadeOutDuration;
      AudioPlayer.Play;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPauseClick(Sender: TObject);
begin
   if (wosPause in AudioPlayer.State) then
       AudioPlayer.Restart
   else
       AudioPlayer.Pause;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   AudioPlayer.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopFadeClick(Sender: TObject);
begin
   AudioPlayer.StopFade(5000);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderPositionTrack(Sender: TObject);
begin
   Seeking := True;
   Label1.Caption := TimeToString(SliderPosition.Position);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderPositionTrackEnd(Sender: TObject);
begin
   Audioplayer.FadeInDuration := 50;
   AudioPlayer.Position := SliderPosition.Position;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AudioPlayerStart(Sender: TObject);
begin
   Timer.Enabled       := True;
   btnPlay.Enabled     := False;
   btnStop.Enabled     := True;
   btnStopFade.Enabled := True;
   btnPause.Enabled    := True;
   //SliderPosition.Enabled := True;
   SliderPitch.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AudioPlayerStop(Sender: TObject);
begin
   Timer.Enabled       := False;
   Timer1.Enabled      := False;
   btnPlay.Enabled     := True;
   btnStop.Enabled     := False;
   btnStopFade.Enabled := False;
   btnPause.Caption    := 'Pause';
   btnPause.Enabled    := False;
   SliderPosition.Position := 0;
   SliderPosition.Enabled := False;
   SliderPitch.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AudioPlayerPause(Sender: TObject);
begin
   btnPause.Caption := 'Resume';
   btnPlay.Enabled  := True;
   btnStopFade.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AudioPlayerRestart(Sender: TObject);
begin
   btnPause.Caption := 'Pause';
   btnPlay.Enabled  := False;
   btnStopFade.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
begin
   if not Seeking then
   begin
      SliderPosition.Position := AudioPlayer.Position;
      Label1.Caption := TimeToString(SliderPosition.Position);
      PlayGauge.Progress :=(SliderPosition.Position*100)div SliderPosition.MaxValue;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderPitchChange(Sender: TObject);
begin
   AudioPlayer.Pitch := SliderPitch.Position;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if (FileStream.Position < FileStream.Size) then
   begin
      CopyData(32768);
      StreamGauge.Progress := (MemStream.Position*100)div MemStream.Size;
   end
   else Timer1.Enabled := False;
end;

end.
